package org.msh.tb;

import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.msh.etbm.commons.transactionlog.mapping.LogInfo;
import org.msh.tb.entities.UserMessage;
import org.msh.tb.entities.Substance;
import org.msh.tb.login.UserSession;
import org.msh.utils.date.DateUtils;

/**
 * Created by Mauricio on 21/07/2017.
 */
@Name("userMessageHome")
@LogInfo(roleName="USER_MESSAGE", entityClass=Substance.class)
public class UserMessagesHome extends EntityHomeEx<UserMessage> {

    @Factory("userMessage")
    public UserMessage getSubstance() {
        return getInstance();
    }

    @Override
    public String persist() {

        boolean isNew = !isManaged();

        getInstance().setUser(UserSession.getUser());
        getInstance().setCreationDate(DateUtils.getDate());

        String ret = super.persist();

        if (isNew) {
            // increment all user workspaces unread message with 1
            getEntityManager().createNativeQuery("update userworkspace set unreadMsgCounter = (unreadMsgCounter+1) " +
                    "where workspace_id = :wsId")
                    .setParameter("wsId", getInstance().getWorkspace().getId())
                    .executeUpdate();
        } else {
            updateAllUserWorkspacesCounters();
        }

        return ret;
    }

    @Override
    public String remove() {
        String ret = super.remove();

        updateAllUserWorkspacesCounters();

        return ret;
    }

    private void updateAllUserWorkspacesCounters(){
        getEntityManager().createNativeQuery("delete from userreadmessage where message_id = :msgId")
                .setParameter("msgId", getInstance().getId())
                .executeUpdate();

        getEntityManager().createNativeQuery("update userworkspace set unreadMsgCounter = (" +
                "(select count(*) from usermessage um where um.workspace_id = :wsId)-" +
                "(select count(*) from userreadmessage urm where urm.USERWORKSPACE_ID = userworkspace.id))" +
                "where userWorkspace.workspace_id = :wsId")
                .setParameter("wsId", getInstance().getWorkspace().getId())
                .executeUpdate();
    }

}
